﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using uPLibrary.Networking.M2Mqtt;

namespace espir_client
{
    public partial class MqttClientSample : Form
    {
        private delegate void SafeCallDelegate(string text);

        MqttClient client;

        Details Detailform = new Details();

        public MqttClientSample()
        {
            InitializeComponent();
        }

        /// <summary>
        /// MQTT接続
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Bt_mqttconnect_Click(object sender, EventArgs e)
        {
            X509Certificate2 caCert = new X509Certificate2(Directory.GetCurrentDirectory() + "/rootca.txt");

            client = new MqttClient(tb_mqttbroker_url.Text, int.Parse(tb_mqttbroker_port.Text), cb_tb_mqttbroker_tls.Checked,  
                caCert, null, MqttSslProtocols.TLSv1_2);

            // SubScribe設定
            client.MqttMsgPublishReceived += (sender, e) => {
                WriteTextSafe(Encoding.UTF8.GetString(e.Message));
                if (e.Topic.EndsWith("learnB64"))
                {
                    Detailform.SetText(Encoding.UTF8.GetString(e.Message));
                }
            };

            // MQTT接続
            string clientId = Guid.NewGuid().ToString();
            byte result = client.Connect(clientId, tb_mqttbroker_userid.Text, tb_mqttbroker_pass.Text, true, 30);

            // QoS
            byte qos = (byte)(rb_qos0.Checked ? 0 : (rb_qos1.Checked ? 1 : 2));

            // Subscribeトピック設定
            client.Subscribe(
                new string[] {
                    String.Format("espir/{0}/{1}/ctrl/learnB64", tb_mqttbroker_userid.Text, tb_target_deviceid.Text)
                    ,String.Format("espir/{0}/{1}/ctrl/login", tb_mqttbroker_userid.Text, tb_target_deviceid.Text)
                }
                , new byte[] { qos, qos });

            // ボタン制御
            SetButtonEnable(client.IsConnected);

            statusLabel.Text = client.IsConnected ? "MQTT接続完了" :
                String.Format("MQTT接続失敗:{0}", result);
        }

        /// <summary>
        /// Subscribeデータを表示(別スレッドのためInvokeを使用)
        /// </summary>
        /// <param name="text"></param>
        private void WriteTextSafe(string text)
        {
            if (tb_payload.InvokeRequired)
            {
                var d = new SafeCallDelegate(WriteTextSafe);
                tb_payload.Invoke(d, new object[] { text });
            }
            else
            {
                tb_payload.Text = text;
            }
        }

        /// <summary>
        /// MQTT切断
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Bt_mqttdisconnect_Click(object sender, EventArgs e)
        {
            client.Disconnect();
            statusLabel.Text = "MQTT未接続";
            SetButtonEnable(false);
        }

        /// <summary>
        /// IR学習要求送信
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void Bt_recv_Click(object sender, EventArgs e)
        {
            client.Publish(
                 String.Format("espir/{0}/{1}/device/irrecvB64", tb_mqttbroker_userid.Text, tb_target_deviceid.Text), null);
        }

        /// <summary>
        /// IR学習データ送信
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void bt_send_Click(object sender, EventArgs e)
        {
            client.Publish(
                 String.Format("espir/{0}/{1}/device/irsendB64", tb_mqttbroker_userid.Text, tb_target_deviceid.Text)
                 , Encoding.UTF8.GetBytes(tb_payload.Text));
        }

        /// <summary>
        /// ボタン制御
        /// </summary>
        /// <param name="enable"></param>
        void SetButtonEnable(bool enable)
        {
            bt_mqttconnect.Enabled = !(bt_mqttdisconnect.Enabled = bt_send.Enabled = bt_recv.Enabled = enable);
        }

        /// <summary>
        /// フォームクローズ時のMQTT切断処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void MqttClientSample_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (client != null && client.IsConnected)
            {
                client.Disconnect();
            }
        }

        private void MqttClientSample_Load(object sender, EventArgs e)
        {
            //コマンドライン引数を配列で取得する
            string[] cmds = System.Environment.GetCommandLineArgs();
            if (cmds.Length != 3)
            {
                return;
            }
            tb_mqttbroker_userid.Text = cmds[1];
            tb_mqttbroker_pass.Text = cmds[2];
        }


        private void BtDetail_Click(object sender, EventArgs e)
        {
            Detailform.Show();
            Detailform.Activate();
        }
    }
}
