﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace espir_client
{
    public partial class Details : Form
    {
        private delegate void SafeCallDelegate(string text);

        public Details()
        {
            InitializeComponent();
        }

        public void SetText(String text)
        {
            if (textBox1.InvokeRequired)
            {
                var d = new SafeCallDelegate(SetText);
                textBox1.Invoke(d, new object[] { GetDetailText(text) });
            }
            else
            {
                textBox1.Text = GetDetailText(text);
            }
        }

        private String GetDetailText(String b64text)
        {
            StringBuilder sb = new StringBuilder();

            // base64データをデコードしてバイト配列を取得
            byte[] irdata = Convert.FromBase64String(b64text);
            byte[] dest = new byte[2];

            // 1ブロックは4バイトでon, offの点灯、消灯時間(us)が2バイトづつ入っている。
            // 先頭1ビットはon/offを表し、ビットが立っている場合は点灯(on)
            for (int i = 0; i < irdata.Length; i+=4)
            {
                Buffer.BlockCopy(irdata, i, dest, 0, 2);
                UInt16 data1 = BitConverter.ToUInt16(dest);
                string d1 = (data1 & 0x8000) > 0 ? "on" : "off";
                data1 = (UInt16)(data1 & 0x7fff);

                Buffer.BlockCopy(irdata, i + 2, dest, 0, 2);
                UInt16 data2 = BitConverter.ToUInt16(dest);
                string d2 = (data2 & 0x8000) > 0 ? "on" : "off";
                data2 = (UInt16)(data2 & 0x7fff);

                sb.Append(String.Format("{0}:{1}, {2}:{3}\r\n", d1, data1, d2, data2));

            }
            return sb.ToString();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void Details_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.Hide();
            e.Cancel = true;
        }
    }
}
